package ru.yandex.search.rules;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public interface SearchService<
    D,
    P extends RequestParams,
    I extends SearchInfo>
{
    P createRequestParams(ProxySession session) throws BadRequestException;

    I createSearchInfo(ProxySession session, P requestParams)
        throws BadRequestException;

    FutureCallback<? super D> createCallback(
        ProxySession session,
        P requestParams,
        I searchInfo)
        throws BadRequestException;
}

