package ru.yandex.search.rules.pure;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class BasicConcatRuleCollector<T, R extends Consumer<T>>
    implements Collector<T, R, R>, BiConsumer<R, T>, BinaryOperator<R>
{
    private final Supplier<R> supplier;

    public BasicConcatRuleCollector(final Supplier<R> supplier) {
        this.supplier = supplier;
    }

    @Override
    public R apply(final R r1, final R r2) {
        return r1;
    }

    @Override
    public Supplier<R> supplier() {
        return supplier;
    }

    @Override
    public void accept(final R r, final T t) {
        r.accept(t);
    }

    @Override
    public BiConsumer<R, T> accumulator() {
        return this;
    }

    @Override
    public BinaryOperator<R> combiner() {
        return this;
    }

    @Override
    public Function<R, R> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Characteristics> characteristics() {
        return Collections.emptySet();
    }
}
