package ru.yandex.search.rules.pure;

import java.util.function.BiFunction;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

public class ChainedSearchRule<T, U, V, R> {
    private final SearchRule<U, R> next;
    private final BiFunction<T, V, U> nextInputFactory;

    public ChainedSearchRule(
        final SearchRule<U, R> next,
        final BiFunction<T, V, U> nextInputFactory)
    {
        this.next = next;
        this.nextInputFactory = nextInputFactory;
    }

    public void execute(
        final T input,
        final V extraData,
        final FutureCallback<? super R> callback)
        throws HttpException
    {
        next.execute(nextInputFactory.apply(input, extraData), callback);
    }
}

