package ru.yandex.search.rules.pure;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class ConcatResultsRule<T extends RequestsProvider, U, R>
    implements SearchRule<T, List<R>>
{
    private final ChainedSearchRule<T, U, String, List<R>> next;

    public ConcatResultsRule(
        final ChainedSearchRule<T, U, String, List<R>> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super List<R>> callback)
        throws HttpException
    {
        List<String> requests = input.requests();
        MultiFutureCallback<List<R>> multiCallback =
            new MultiFutureCallback<>(new Callback<>(callback));
        for (String request: requests) {
            next.execute(input, request, multiCallback.newCallback());
        }
        multiCallback.done();
    }

    private static class Callback<R>
        extends AbstractFilterFutureCallback<List<List<R>>, List<R>>
    {
        Callback(final FutureCallback<? super List<R>> callback) {
            super(callback);
        }

        @Override
        public void completed(final List<List<R>> results) {
            List<R> allResults = new ArrayList<>();
            for (List<R> result: results) {
                allResults.addAll(result);
            }
            callback.completed(allResults);
        }
    }
}

