package ru.yandex.search.rules.pure;

import java.util.List;
import java.util.stream.Collector;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class GenericConcatResultsRule<T extends RequestsProvider, U, IR, OR>
    implements SearchRule<T, OR>
{
    private final ChainedSearchRule<T, U, String, IR> next;
    private final Collector<IR, OR, OR> collector;

    public GenericConcatResultsRule(
        final Collector<IR, OR, OR> collector,
        final ChainedSearchRule<T, U, String, IR> next)
    {
        this.next = next;
        this.collector = collector;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super OR> callback)
        throws HttpException
    {
        List<String> requests = input.requests();
        MultiFutureCallback<IR> multiCallback =
            new MultiFutureCallback<>(new Callback(callback));
        for (String request: requests) {
            next.execute(input, request, multiCallback.newCallback());
        }
        multiCallback.done();
    }

    private class Callback
        extends AbstractFilterFutureCallback<List<IR>, OR>
    {
        Callback(final FutureCallback<? super OR> callback) {
            super(callback);
        }

        @Override
        public void completed(final List<IR> results) {
            OR result = collector.supplier().get();
            for (IR item: results) {
                collector.accumulator().accept(result, item);
            }

            callback.completed(collector.finisher().apply(result));
        }
    }
}
