package ru.yandex.search.rules.pure;

import java.util.List;

import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.client.producer.ProducerClient;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.search.rules.pure.providers.ProxySessionProvider;
import ru.yandex.search.rules.pure.providers.UserProvider;

@SuppressWarnings("FutureReturnValueIgnored")
public class ResolveBackendsRule<
    T extends ProxySessionProvider & UserProvider,
    U,
    R>
    implements SearchRule<T, R>
{
    private final ChainedSearchRule<T, U, List<HttpHost>, R> next;
    private final ProducerClient producerClient;
    private final SearchMap searchMap;

    public ResolveBackendsRule(
        final ChainedSearchRule<T, U, List<HttpHost>, R> next,
        final ProducerClient producerClient,
        final SearchMap searchMap)
    {
        this.next = next;
        this.producerClient = producerClient;
        this.searchMap = searchMap;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super R> callback)
    {
        Callback backendsCallback = new Callback(callback, input);
        if (producerClient == null) {
            backendsCallback.completed(searchMap.searchHosts(input.user()));
        } else {
            ProxySession session = input.proxySession();
            ProducerClient producerClient =
                this.producerClient.adjust(session.context());
            producerClient.execute(
                input.user(),
                session.listener().createContextGeneratorFor(producerClient),
                backendsCallback);
        }
    }

    private class Callback
        extends AbstractFilterFutureCallback<List<HttpHost>, R>
    {
        private final T input;

        Callback(
            final FutureCallback<? super R> callback,
            final T input)
        {
            super(callback);
            this.input = input;
        }

        @Override
        public void completed(final List<HttpHost> hosts) {
            if (hosts.isEmpty()) {
                failed(
                    new NotFoundException(
                        "No hosts found for user: " + input.user()));
            } else {
                try {
                    next.execute(input, hosts, callback);
                } catch (Exception e) {
                    failed(e);
                }
            }
        }
    }
}

