package ru.yandex.parser.searchmap;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.prefix.PrefixType;

public class ImmutableSearchMapConfig implements SearchMapConfig {
    private final String content;
    private final File file;
    private final PrefixType prefixType;
    private final String searchPortName;
    private final String fallbackSearchPortName;
    private final String indexerPortName;
    private final String fallbackIndexerPortName;
    private final boolean ignoreSkipSearch;

    public ImmutableSearchMapConfig(final SearchMapConfig config)
        throws ConfigException
    {
        content = config.content();
        file = config.file();
        prefixType = config.prefixType();
        searchPortName = config.searchPortName();
        fallbackSearchPortName = config.fallbackSearchPortName();
        indexerPortName = config.indexerPortName();
        fallbackIndexerPortName = config.fallbackIndexerPortName();
        ignoreSkipSearch = config.ignoreSkipSearch();
        if (content == null && file == null) {
            throw new ConfigException("Searchmap source is not set");
        }
        if (prefixType == null) {
            throw new ConfigException("Prefix type is not set");
        }
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public PrefixType prefixType() {
        return prefixType;
    }

    @Override
    public String searchPortName() {
        return searchPortName;
    }

    @Override
    public String fallbackSearchPortName() {
        return fallbackSearchPortName;
    }

    @Override
    public String indexerPortName() {
        return indexerPortName;
    }

    @Override
    public String fallbackIndexerPortName() {
        return fallbackIndexerPortName;
    }

    @Override
    public boolean ignoreSkipSearch() {
        return ignoreSkipSearch;
    }

    public SearchMap build() throws IOException, ParseException {
        return new SearchMap(this);
    }
}

