package ru.yandex.parser.searchmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.collection.LazyList;

public class PrefixInfo {
    private final User user;
    private final Collection<SearchMapHost> hosts;

    public PrefixInfo(final User user, final Collection<SearchMapHost> hosts) {
        this.user = user;
        this.hosts = hosts;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Prefix: ");
        sb.append(user.prefix());
        sb.append(", hash: ");
        sb.append(user.prefix().hash());
        sb.append(", type: ");
        sb.append(user.prefix().type());
        if (hosts.isEmpty()) {
            sb.append("\nNo hosts found for ");
            sb.append(user.toString());
        } else {
            sb.append("\nHosts:");
            for (SearchMapHost host: hosts) {
                sb.append('\n');
                sb.append(host.toString());
            }
        }
        return new String(sb);
    }

    public Map<String, Object> toMap() {
        Map<String, Object> info = new HashMap<>();
        info.put("prefix", user.prefix());
        info.put("hash", user.prefix().hash());
        info.put("type", user.prefix().type());
        info.put(
            "hosts",
            new LazyList<SearchMapHost, Map<String, Object>>(
                new ArrayList<SearchMapHost>(hosts),
                SearchMapHostToInfo.INSTANCE));
        return info;
    }
}
