package ru.yandex.parser.searchmap;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.prefix.PrefixType;

public class SearchMapConfigBuilder implements SearchMapConfig {
    private String content;
    private File file;
    private PrefixType prefixType;
    private String searchPortName;
    private String fallbackSearchPortName;
    private String indexerPortName;
    private String fallbackIndexerPortName;
    private boolean ignoreSkipSearch;

    public SearchMapConfigBuilder() {
        this(SearchMapConfigDefaults.INSTANCE);
    }

    public SearchMapConfigBuilder(final SearchMapConfig config) {
        content = config.content();
        file = config.file();
        prefixType = config.prefixType();
        searchPortName = config.searchPortName();
        fallbackSearchPortName = config.fallbackSearchPortName();
        indexerPortName = config.indexerPortName();
        fallbackIndexerPortName = config.fallbackIndexerPortName();
        ignoreSkipSearch = config.ignoreSkipSearch();
    }

    public SearchMapConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, SearchMapConfigDefaults.INSTANCE);
    }

    public SearchMapConfigBuilder(
        final IniConfig config,
        final SearchMapConfig defaults)
        throws ConfigException
    {
        content = null;
        file = config.getInputFile("file", defaults.file());
        prefixType = config.getEnum(
            PrefixType.class,
            "prefix-type",
            defaults.prefixType());
        searchPortName = config.getString(
            "search-port-name",
            defaults.searchPortName());
        fallbackSearchPortName = config.getString(
            "fallback-search-port-name",
            defaults.fallbackSearchPortName());
        indexerPortName = config.getString(
            "indexer-port-name",
            defaults.indexerPortName());
        fallbackIndexerPortName = config.getString(
            "fallback-indexer-port-name",
            defaults.fallbackIndexerPortName());
        ignoreSkipSearch = config.getBoolean(
            "ignore-skip-search",
            defaults.ignoreSkipSearch());
    }

    @Override
    public String content() {
        return content;
    }

    public SearchMapConfigBuilder content(final String content) {
        this.content = content;
        if (content != null) {
            file = null;
        }
        return this;
    }

    @Override
    public File file() {
        return file;
    }

    public SearchMapConfigBuilder file(final File file) {
        this.file = file;
        if (file != null) {
            content = null;
        }
        return this;
    }

    @Override
    public PrefixType prefixType() {
        return prefixType;
    }

    public SearchMapConfigBuilder prefixType(final PrefixType prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    @Override
    public String searchPortName() {
        return searchPortName;
    }

    public SearchMapConfigBuilder searchPortName(final String searchPortName) {
        this.searchPortName = searchPortName;
        return this;
    }

    @Override
    public String fallbackSearchPortName() {
        return fallbackSearchPortName;
    }

    public SearchMapConfigBuilder fallbackSearchPortName(
        final String fallbackSearchPortName)
    {
        this.fallbackSearchPortName = fallbackSearchPortName;
        return this;
    }

    @Override
    public String indexerPortName() {
        return indexerPortName;
    }

    public SearchMapConfigBuilder indexerPortName(
        final String indexerPortName)
    {
        this.indexerPortName = indexerPortName;
        return this;
    }

    @Override
    public String fallbackIndexerPortName() {
        return fallbackIndexerPortName;
    }

    public SearchMapConfigBuilder fallbackIndexerPortName(
        final String fallbackIndexerPortName)
    {
        this.fallbackIndexerPortName = fallbackIndexerPortName;
        return this;
    }

    @Override
    public boolean ignoreSkipSearch() {
        return ignoreSkipSearch;
    }

    public SearchMapConfigBuilder ignoreSkipSearch(
        final boolean ignoreSkipSearch)
    {
        this.ignoreSkipSearch = ignoreSkipSearch;
        return this;
    }

    public ImmutableSearchMapConfig build() throws ConfigException {
        return new ImmutableSearchMapConfig(this);
    }
}

