package ru.yandex.parser.searchmap;

import java.util.Objects;

import org.apache.http.HttpHost;

public class SearchMapHost {
    private final HttpHost searchHost;
    private final HttpHost indexerHost;
    private final int hashCode;

    public SearchMapHost(
        final String hostname,
        final int searchPort,
        final int indexerPort)
    {
        this.searchHost = host(hostname, searchPort);
        this.indexerHost = host(hostname, indexerPort);
        hashCode =
            Objects.hashCode(searchHost) ^ Objects.hashCode(indexerHost);
    }

    public SearchMapHost(final SearchMapLine line) {
        this(line.host(), line.searchPort(), line.indexerPort());
    }

    private static HttpHost host(final String hostname, final int port) {
        if (port == -1) {
            return null;
        } else {
            return new HttpHost(hostname, port);
        }
    }

    public HttpHost searchHost() {
        return searchHost;
    }

    public HttpHost indexerHost() {
        return indexerHost;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    // CSOFF: ReturnCount
    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SearchMapHost) {
            SearchMapHost other = (SearchMapHost) o;
            return hashCode == other.hashCode
                && Objects.equals(searchHost, other.searchHost)
                && Objects.equals(indexerHost, other.indexerHost);
        }
        return false;
    }
    // CSON: ReturnCount

    @Override
    public String toString() {
        return "[search: " + searchHost
            + ", index: " + indexerHost + ']';
    }
}

