package ru.yandex.parser.searchmap;

import java.util.Arrays;
import java.util.List;

import ru.yandex.search.prefix.PrefixType;

public class SearchMapRow {
    private final SearchMapShard[] shards =
        new SearchMapShard[(int) SearchMap.SHARDS_COUNT];
    private final PrefixType prefixType;

    public SearchMapRow(final PrefixType prefixType) {
        this.prefixType = prefixType;
    }

    public PrefixType prefixType() {
        return prefixType;
    }

    // CSOFF: ParameterNumber
    public void add(
        final int shardNumber,
        final List<ZooKeeperAddress> zk,
        final SearchMapHost host,
        final int iNum)
    {
        SearchMapShard shard = shards[shardNumber];
        if (shard == null) {
            shard = new SearchMapShard(zk, iNum);
            shards[shardNumber] = shard;
        } else if (!zk.equals(shard.zk())) {
            throw new IllegalArgumentException(
                "Mismatched zk list for shard " + shardNumber
                + ", expected: " + shard.zk() + ", got: " + zk);
//        } else if (iNum != shard.iNum()) {
//            throw new IllegalArgumentException("");
        }
        shard.append(host);
    }
    // CSON: ParameterNumber

    public void replace(final int index, final SearchMapShard shard) {
        shards[index] = shard;
    }

    public SearchMapShard get(final int index) {
        return shards[index];
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(shards) ^ prefixType.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof SearchMapRow) {
            SearchMapRow other = (SearchMapRow) o;
            return prefixType == other.prefixType
                && Arrays.equals(shards, other.shards);
        }
        return false;
    }
}

