package ru.yandex.parser.searchmap;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class SearchMapShard extends AbstractList<SearchMapHost> {
    private static final int INITIAL_HOSTS_CAPACITY = 10;

    private final List<ZooKeeperAddress> zk;
    private final int iNum;
    private SearchMapHost[] hosts =
        new SearchMapHost[INITIAL_HOSTS_CAPACITY];
    private int size = 0;
    private int hashCode;

    public SearchMapShard(final List<ZooKeeperAddress> zk, final int iNum) {
        this.zk = zk;
        this.iNum = iNum;
        hashCode = zk.hashCode();
    }

    public List<ZooKeeperAddress> zk() {
        return zk;
    }

    private boolean contains(final SearchMapHost host) {
        for (int i = 0; i < size; ++i) {
            if (hosts[i].equals(host)) {
                return true;
            }
        }
        return false;
    }

    public void append(final SearchMapHost host) {
        if (!contains(host)) {
            if (size == hosts.length) {
                hosts = Arrays.copyOf(hosts, size << 1);
            }
            hosts[size++] = host;
            hashCode += host.hashCode();
        }
    }

    @Override
    public SearchMapHost get(final int index) {
        return hosts[index];
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    public int iNum() {
        return iNum;
    }

    // CSOFF: ReturnCount
    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SearchMapShard) {
            SearchMapShard other = (SearchMapShard) o;
            if (size == other.size
                && hashCode == other.hashCode
                && zk.equals(other.zk))
            {
                for (int i = 0; i < size; ++i) {
                    if (!other.contains(hosts[i])) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
    // CSON: ReturnCount
}

