package ru.yandex.parser.searchmap;

import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.string.Parser;
import ru.yandex.parser.string.Validator;

public class ShardNumberValidator extends Validator<Long> {
    public static final ShardNumberValidator INSTANCE =
        new ShardNumberValidator(NonNegativeLongValidator.INSTANCE);

    public ShardNumberValidator(final Parser<Long> parser) {
        super(parser);
    }

    @Override
    public void validate(final Long value) throws Exception {
        if (value >= SearchMap.SHARDS_COUNT) {
            throw new IllegalArgumentException(
                "Value must not exceed max shard count");
        }
    }
}

