package ru.yandex.parser.searchmap;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.search.prefix.Prefix;

public class User extends AbstractStringBuilderable {
    private final String service;
    private final Prefix prefix;

    public User(final String service, final Prefix prefix) {
        this.service = service;
        this.prefix = prefix;
    }

    public String service() {
        return service;
    }

    public Prefix prefix() {
        return prefix;
    }

    public long shard() {
        return prefix.hash() % SearchMap.SHARDS_COUNT;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof User) {
            User other = (User) o;
            return service.equals(other.service)
                && prefix.equals(other.prefix);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return service.hashCode() ^ prefix.hashCode();
    }

    @Override
    public int expectedStringLength() {
        return prefix.expectedStringLength() + service.length() + 1;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        prefix.toStringBuilder(sb);
        sb.append('@');
        sb.append(service);
    }
}

