package ru.yandex.parser.searchmap;

import org.apache.http.HttpHost;

public class ZooKeeperAddress {
    private final HttpHost host;
    private final int zkPort;

    public ZooKeeperAddress(final HttpHost host, final int zkPort) {
        this.host = host;
        this.zkPort = zkPort;
    }

    public HttpHost host() {
        return host;
    }

    public int zkPort() {
        return zkPort;
    }

    @Override
    public int hashCode() {
        return host.hashCode() ^ zkPort;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof ZooKeeperAddress) {
            ZooKeeperAddress other = (ZooKeeperAddress) o;
            return zkPort == other.zkPort && host.equals(other.host);
        }
        return false;
    }

    @Override
    public String toString() {
        return host.getHostName() + ':' + zkPort + '/' + host.getPort();
    }
}

