package ru.yandex.parser.searchmap;

import org.apache.http.HttpHost;

import ru.yandex.function.GenericFunction;

public enum ZooKeeperAddressParser
    implements GenericFunction<String, ZooKeeperAddress, RuntimeException>
{
    INSTANCE;

    @Override
    public ZooKeeperAddress apply(final String value) {
        int colon = value.indexOf(':');
        String host = value.substring(0, colon);
        String ports = value.substring(colon + 1);
        int zkPort;
        int httpPort;
        int slash = ports.indexOf('/');
        if (slash == -1) {
            zkPort = Integer.parseInt(ports);
            httpPort = Integer.parseInt('8' + ports.substring(1));
        } else {
            zkPort = Integer.parseInt(ports.substring(0, slash));
            httpPort = Integer.parseInt(ports.substring(slash + 1));
        }
        return new ZooKeeperAddress(new HttpHost(host, httpPort), zkPort);
    }
}

