#!/bin/bash -x

mkdir -p /dev/shm/gclogs

source $BSCONFIG_IDIR/shivaka/classpath.sh

# params existed as enviroment in YP
#export CPU_GUARANTEE=6.649c
#export CPU_LIMIT=6.649c

#export MEM_GUARANTEE=12884901888
#export MEM_LIMIT=12884901888

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

export GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx$MEMORY_LIMIT
-Xms1G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:ShenandoahGCMode=iu
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=$BSCONFIG_IDIR/shivaka \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DHOMEDIR=$BSCONFIG_IDIR \
    -cp $CLASSPATH \
    ru.yandex.search.mail.shivaka.Shivaka \
    $BSCONFIG_IDIR/shivaka/$1
