package ru.yandex.search.mail.shivaka;

import java.util.Collections;
import java.util.Map;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;

public class ImmutableShivakaConfig
    extends ImmutableHttpProxyConfig
    implements ShivakaConfig
{
    private final ImmutableSearchMapConfig searchMapConfig;
    private final ImmutableHttpTargetConfig queueConfig;
    private final long statUpdateDelay;
    private final String queueSuffix;
    private final Map<String, String> localMonitoringConfig;
    private final Map<String, String> localConsumerServiceConfig;
    private final String filterHostPattern;

    public ImmutableShivakaConfig(final ShivakaConfig config)
        throws ConfigException
    {
        super(config);
        searchMapConfig = new ImmutableSearchMapConfig(
                config.searchMapConfig());
        queueConfig = new ImmutableHttpTargetConfig(
                config.queueConfig());

        statUpdateDelay = STAT_UPDATE_DELAY.validate(config.statUpdateDelay());
        queueSuffix = QUEUE_SUFFIX.validate(config.queueSuffix());

        localMonitoringConfig =
            Collections.unmodifiableMap(config.localMonitoringConfig());

        localConsumerServiceConfig =
            Collections.unmodifiableMap(config.localConsumerServiceConfig());

        filterHostPattern = FILTER_HOST_PATTERN.validate(config.filterHostPattern());

    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public ImmutableHttpTargetConfig queueConfig() {
        return queueConfig;
    }

    @Override
    public long statUpdateDelay() {
        return statUpdateDelay;
    }

    @Override
    public String queueSuffix() {
        return queueSuffix;
    }

    @Override
    public Map<String, String> localMonitoringConfig() {
        return localMonitoringConfig;
    }

    @Override
    public Map<String, String> localConsumerServiceConfig() {
        return localConsumerServiceConfig;
    }

    @Override
    public String filterHostPattern() {
        return filterHostPattern;
    }

}

