package ru.yandex.search.mail.shivaka;

public class QueuelenString {
    public static final QueuelenString INSTANCE = new QueuelenString();

    private static final int CONSUMER_POSITION_INDEX = 5;
    private static final int CONSUMER_POSTITION_UPDATE_MTIME_INDEX = 7;
    private static final int CONSUMER_QUEUE_SIZE_INDEX = 3;
    private static final int CONSUMER_TIME_LAG_INDEX = 8;
    private static final int HOSTNAME_INDEX = 2;
    private static final int QUEUE_POSITION_INDEX = 4;
    private static final int QUEUE_POSITION_UPDATE_MTIME_INDEX = 6;
    private static final int SERVICE_INDEX = 0;
    private static final int SHARD_INDEX = 1;
    private final Integer shard;
    private final Long consumerPosition;
    private final Long consumerPositionUpdateMtime;
    private final Long consumerQueueSize;
    private final Long consumerTimeLag;
    private final Long queuePosition;
    private final Long queuePositionUpdateMtime;
    private final String hostname;
    private final String service;

    public QueuelenString(final String line) {
        //line example:
        // opqueue 1051 man1-0123.search.yandex.net 40852 2515497 ...
        String[] tokens = line.split("\\t+");
        this.service
                = tokens[SERVICE_INDEX];
        this.shard
                = Integer.parseInt(tokens[SHARD_INDEX]);
        this.hostname
                = tokens[HOSTNAME_INDEX];
        this.consumerQueueSize
                = Long.parseLong(tokens[CONSUMER_QUEUE_SIZE_INDEX]);
        this.queuePosition
                = Long.parseLong(tokens[QUEUE_POSITION_INDEX]);
        this.consumerPosition
                = Long.parseLong(tokens[CONSUMER_POSITION_INDEX]);
        this.queuePositionUpdateMtime
                = Long.parseLong(tokens[QUEUE_POSITION_UPDATE_MTIME_INDEX]);
        this.consumerPositionUpdateMtime
                = Long.parseLong(tokens[CONSUMER_POSTITION_UPDATE_MTIME_INDEX]);
        this.consumerTimeLag
                = Long.parseLong(tokens[CONSUMER_TIME_LAG_INDEX]);
    }

    private QueuelenString() {
        this.service = "false";
        this.shard = 0;
        this.hostname = "false2";
        this.consumerQueueSize = 0L;
        this.queuePosition = 0L;
        this.consumerPosition = 0L;
        this.queuePositionUpdateMtime = 0L;
        this.consumerPositionUpdateMtime = 0L;
        this.consumerTimeLag = 0L;
    }

    public String service() {
        return this.service;
    }

    public Integer shard() {
        return this.shard;
    }

    public String hostname() {
        return this.hostname;
    }

    public Long consumerQueueSize() {
        return this.consumerQueueSize;
    }

    public Long queuePositionservice() {
        return this.queuePosition;
    }

    public Long consumerPosition() {
        return this.consumerPosition;
    }

    public Long queuePositionUpdateMtime() {
        return this.queuePositionUpdateMtime;
    }

    public Long consumerPositionUpdateMtime() {
        return this.consumerPositionUpdateMtime;
    }

    public Long consumerTimeLag() {
        return this.consumerTimeLag;
    }
}
