package ru.yandex.search.mail.shivaka;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.util.server.HttpProxyConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PatternValidator;

public interface ShivakaConfig extends HttpProxyConfig {
    ParameterConfig<Long> STAT_UPDATE_DELAY = new ParameterConfig<>(
            "stat-update-delay",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            NonNegativeValidator.instance());

    ParameterConfig<String> QUEUE_SUFFIX = new ParameterConfig<>(
            "queue-suffix",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<String> FILTER_HOST_PATTERN = new ParameterConfig<>(
            "filter-host-pattern",
            GenericFunction.identity(),
            PatternValidator.INSTANCE);

    long statUpdateDelay();

    String queueSuffix();

    SearchMapConfig searchMapConfig();

    HttpTargetConfig queueConfig();

    Map<String, String> localMonitoringConfig();

    Map<String, String> localConsumerServiceConfig();

    String filterHostPattern();
}

