package ru.yandex.search.mail.shivaka;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ShivakaConfigBuilder
    extends AbstractShivakaConfigBuilder<ShivakaConfigBuilder>
{
    public ShivakaConfigBuilder() {
        super(ShivakaConfigDefaults.INSTANCE);
    }

    public ShivakaConfigBuilder(final ShivakaConfig config) {
        super(config);
    }

    public ShivakaConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ShivakaConfigDefaults.INSTANCE);
    }

    public ShivakaConfigBuilder(
        final IniConfig config,
        final ShivakaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ShivakaConfigBuilder self() {
        return this;
    }

    public ImmutableShivakaConfig build() throws ConfigException {
        return new ImmutableShivakaConfig(this);
    }
}

