package ru.yandex.search.mail.shivaka;

import java.util.Collections;
import java.util.Map;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigDefaults;

public class ShivakaConfigDefaults
    extends HttpProxyConfigDefaults
    implements ShivakaConfig
{
    public static final ShivakaConfigDefaults INSTANCE =
        new ShivakaConfigDefaults();

    protected ShivakaConfigDefaults() {
    }

    @Override
    public String name() {
        return "Shivaka";
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return SearchMapConfigDefaults.INSTANCE;
    }

    @Override
    public HttpTargetConfig queueConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public long statUpdateDelay() {
        return -1L;
    }

    @Override
    public String queueSuffix() {
        return "/queuelen";
    }

    @Override
    public Map<String, String> localMonitoringConfig() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> localConsumerServiceConfig() {
        return Collections.emptyMap();
    }

    @Override
    public String filterHostPattern() {
        return "";
    }
}

