package ru.yandex.search.mail.shivaka;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.QueryConstructor;

public class ShivakaHandler implements ProxyRequestHandler {
    private String service;
    private final Shivaka shivaka;

    public ShivakaHandler(final Shivaka shivaka) {
        this.shivaka = shivaka;
    }

    @Override
    public void handle(
            final ProxySession session)
            throws HttpException, IOException
    {
        service = session.params().get(
                "service",
                NonEmptyValidator.INSTANCE);

        shivaka.logger().info("service:" + service);

        AsyncClient client =
                shivaka.queueClient().adjust(session.context());
        QueryConstructor qc =
                new QueryConstructor("/queuelen");
        client.execute(
                shivaka.config().queueConfig().proxy(),
                new BasicAsyncRequestProducerGenerator(qc.toString()),
                AsyncStringConsumerFactory.OK,
                session.listener().adjustContextGenerator(
                        client.httpClientContextGenerator()),
                new QueueInfoCallback(session));
    }

    private final class QueueInfoCallback
            extends AbstractProxySessionCallback<String>
    {
        private QueueInfoCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final String serp) {
            shivaka.logger().info("queue answer:" + serp);
        }
    }
}
