package ru.yandex.search.mail.shivaka;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public class ShivakaRequestContext {
    private final String service;
    private final List<String> nannyServices;

    private final Shivaka shivaka;
    private final ProxySession session;

    public ShivakaRequestContext(
            final Shivaka shivaka,
            final ProxySession session)
        throws BadRequestException
    {
        this.shivaka = shivaka;
        this.session = session;
        service = session.params().get(
                "service",
                NonEmptyValidator.INSTANCE);
        nannyServices = session.params().get(
                "nanny-services",
                new CollectionParser<>(
                        NonEmptyValidator.INSTANCE,
                        ArrayList::new));
    }

    public Shivaka shivaka() {
        return shivaka;
    }

    public ProxySession session() {
        return session;
    }

    public List<String> nannyServices() {
        return nannyServices;
    }

    public String service() {
        return service;
    }
}

