package ru.yandex.search.mail.shivaka.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.mail.shivaka.Shivaka;

public class ShivakaTemplateHandler implements ProxyRequestHandler {
    private final Shivaka shivaka;
    private final Map<String, ArrayList<ArrayList<String>>> monitoringTemplate;

    public ShivakaTemplateHandler(final Shivaka shivaka) {
        this.shivaka = shivaka;
        this.monitoringTemplate = new HashMap<>();

                /*JsonMap jsonmap = new JsonMap(BasicContainerFactory.INSTANCE);
        jsonmap.put("change_log", new JsonString("test2"));

        monTemplate.put("template", jsonmap);

        JsonList jsonlist = new JsonList(BasicContainerFactory.INSTANCE);
        jsonlist.add(new JsonString("qwer"));

        monTemplate.put("consumer_service", jsonlist);*/

        /*for (String service : this.shivaka.queuelenStat()
            .getQueuestat()
            .keySet())*/

        /*this.shivaka.logger().info("services:"
            + this.shivaka.queuelenStat().getQueuestat().keySet());*/
    }

    @Override
    public void handle(
            final ProxySession session)
            throws HttpException, IOException
    {
        this.monitoringTemplate.clear();
        for (String service : this.shivaka
            .queuelenStat()
            .getQueuestat()
            .keySet())
        {
            ArrayList<ArrayList<String>> serviceinfo =
                monitoringTemplate.computeIfAbsent(
                    service,
                    k -> new ArrayList<>()
                );
            for (Map.Entry<String, String> monSection: this.shivaka.config().
                localMonitoringConfig().entrySet())
            {
                ArrayList<String> listinner = new ArrayList<>();
                listinner.add(monSection.getKey());
                listinner.add(monSection.getValue());
                serviceinfo.add(listinner);
            }
        }

        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(monitoringTemplate));
    }
}
