package ru.yandex.search.mail.shivaka.tasks;

import java.io.IOException;
import java.util.TimerTask;

import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import ru.yandex.json.parser.JsonException;
import ru.yandex.search.mail.shivaka.Shivaka;

public class RenewStatTask extends TimerTask {
    private final String renewStatUrl;

    private final Shivaka shivaka;

    public RenewStatTask(final Shivaka shivaka) {
        this.shivaka = shivaka;
        renewStatUrl = "http://localhost:"
                + this.shivaka.config().port()
                + "/renewstat";
    }

    private void requestNewStat()
            throws HttpException, IOException, JsonException
    {
        shivaka.logger().info("Newstat was requested");

        HttpGet get = new HttpGet(renewStatUrl);
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute(get);
        shivaka.logger().info("Response is:"
                + response.getEntity());
    }

    @Override
    public void run() {
        try {
            requestNewStat();
        } catch (Throwable t) {
            shivaka.logger().info("Renewstat failed.");
        }
    }
}
