#!/bin/bash
set -exo pipefail

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)
export CONSUMER_PREFETCH_COUNT=30
export SERVICE_CONFIG=null.conf
if [ -f $(hostname)".conf" ]; then
    export HOST_CONFIG=$(hostname)".conf"
else
    export HOST_CONFIG="null-host.conf"
fi
export RESPONSELESS="true"
export INDEX_DIR=/ssd
export SHARDS=31

case "$NANNY_SERVICE_ID" in
    so_fraud_data_backend)
        export FIELDS_CONF_DIR=so_fraud_data
        export SHARDS=1
        ;;
    so_fraud_data_main_backend)
        export FIELDS_CONF_DIR=antitrust
        export SHARDS=217
        export ZK_SERVICE="so_fraud_data"
        ;;
    so_fraud_data_aggrs_backend)
        export FIELDS_CONF_DIR=antitrust
        ;;
    so_fraud_data_history_backend)
        export SERVICE_CONFIG=history.conf
        export FIELDS_CONF_DIR=antitrust
        export INDEX_DIR=/hdd
        ;;
    so_fraud_passport_backend)
        export SHARDS=1
        export INDEX_THREADS=6
        export FIELDS_CONF_DIR=passport
        export CONSUMER_PREFETCH_COUNT=300
        ;;
    so_fraud_passport_cnt_backend)
        export SHARDS=1
        export INDEX_THREADS=6
        export FIELDS_CONF_DIR=passport
        export CONSUMER_PREFETCH_COUNT=300
        ;;
    so_fraud_passport_main_backend)
        export SHARDS=217
        export INDEX_THREADS=6
        export FIELDS_CONF_DIR=passport
        export CONSUMER_PREFETCH_COUNT=300
        export ZK_SERVICE="so_fraud_passport"
        ;;
    so_fraud_passport_aggrs_backend)
        export INDEX_THREADS=6
        export FIELDS_CONF_DIR=passport
        export CONSUMER_PREFETCH_COUNT=100
        ;;
    shakur_backend)
        export FIELDS_CONF_DIR=shakur
        export CONSUMER_PREFETCH_COUNT=100
        ;;
    so_fraud_login_id_backend)
        export FIELDS_CONF_DIR=login_id
        ;;
    so_fraud_list_backend)
        export FIELDS_CONF_DIR=list
        ;;
    so_fraud_testing_backend)
        export FIELDS_CONF_DIR=testing
        export INDEX_THREADS=1
        export SHARDS=1
        ;;
    *)
        ;;
esac
