#!/bin/bash

ZK_SERVICE=$1
NANNY_SERVICE=$2
STATIC_ONLY=$3

if [ "$NANNY_SERVICE" == "so_fraud_data_main_backend" ]; then
static='
##qweqwe
'
else
static='
'
fi

echo "$static"
if [ "$STATIC_ONLY" != "" ]; then
    exit 0
fi

if [ "$NANNY_SERVICE" == "so_fraud_data_main_backend" ]; then
    DCs=("sas" "vla")
else
    DCs=("sas" "vla" "man")
fi
NANNY_SERVICE=$(echo $NANNY_SERVICE | tr '_' '-')
ZK="zk:sas1-8797-c8a-sas-personal-queue1-18274.gencfg-c.yandex.net:18274/18275|sas2-2716-4b1-sas-personal-queue1-18274.gencfg-c.yandex.net:18274/18275|sas2-2719-eba-sas-personal-queue1-18274.gencfg-c.yandex.net:18274/18275|man1-8312-man-personal-queue1-21850.gencfg-c.yandex.net:21850/21851|man1-8316-man-personal-queue1-21850.gencfg-c.yandex.net:21850/21851|man2-0252-man-personal-queue1-21850.gencfg-c.yandex.net:21850/21851|vla1-2066-vla-personal-queue1-28456.gencfg-c.yandex.net:28456/28457|vla1-2229-vla-personal-queue1-28456.gencfg-c.yandex.net:28456/28457|vla2-9335-021-vla-personal-queue1-28456.gencfg-c.yandex.net:28456/28457"
ZK_START_SHARD=1000
ZK_END_SHARD=2000
SERVER_COUNT=10
REPLICA_FACTOR=2
STEP=7
PORTS="json_indexer_port:82,search_port_ng:81,search_port:80"

INUMS=$((SERVER_COUNT/REPLICA_FACTOR))
for DC in "${DCs[@]}"
do
    INUM=0
    for ((i = ZK_START_SHARD - 1; i + STEP <= ZK_END_SHARD; i += STEP, INUM++))
    do
        START=$((i + 1))
        INUM=$((INUM%INUMS))
        for ((r = 0; r < REPLICA_FACTOR; r++))
        do
            SERVER_NUM=$((INUM + (INUMS * r) + 1))
            SHORT_NAME=$NANNY_SERVICE"-"$SERVER_NUM"."$DC
            TAG="tag:"$SHORT_NAME
            HOST="host:"$SHORT_NAME".yp-c.yandex.net"
            SHARDS="shards:"$START"-"$((i + STEP))
            echo $ZK_SERVICE" iNum:"$INUM","$SHARDS","$TAG","$HOST","$ZK","$PORTS
        done
#        echo -e "\n\n##$dc" >> searchmap.txt
#        echo "$ZK_SERVICE $iNum"
    done
done
