#!/bin/bash
set -exo pipefail
source config.sh
source classpath.sh

GRAALJS=\
jdk/graaljs/1.8/graaljs.jar:\
jdk/graaljs/1.8/graaljs-scriptengine.jar:\
jdk/graaljs/1.8/graal-sdk.jar:\
jdk/graaljs/1.8/icu4j.jar:\
jdk/graaljs/1.8/truffle-api.jar:\
jdk/graaljs/1.8/asm-7.1.jar:\
jdk/graaljs/1.8/asm-commons-7.1.jar:\
jdk/graaljs/1.8/asm-util-7.1.jar

if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 + 0.2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*86))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.86)}')
fi

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1.5c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/lstorage_service
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

source gc_args.sh

MULTISTARTER_CONFIGS="\
ru.yandex.dispatcher.consumer.ConsumerServer -config so_fraud_consumer.conf ; \
ru.yandex.msearch.Daemon -config so_fraud_backend.conf "

export INDEX_THREADS=${INDEX_THREADS:-4}
export MERGE_THREADS=2
export SEARCH_THREADS=$((CPU_CORES - 1))
export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))
export SEARCH_THREADS=$((SEARCH_THREADS * 2))
export LIMIT_SEARCH_REQUESTS=$((SEARCH_THREADS - 1))
if [ $SEARCH_THREADS -le 0 ]; then
    SEARCH_THREADS=1
    LIMIT_SEARCH_REQUESTS=1
fi

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=.:so_fraud_backend \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -XX:+CrashOnOutOfMemoryError \
    -DPORTO=1 \
    -cp $CLASSPATH:$GRAALJS \
    ru.yandex.multistarter.MultiStarter \
    $MULTISTARTER_CONFIGS
