#!/bin/bash

> staters.conf

SERVICES=("so_fraud_passport" "so_fraud_data")
TYPES=(
    "MAIN"
    "AGGRS"
    "FAST_LIST"
    "COUNTERS"
    "COLLAPSED_AGGRS")

for s in "${SERVICES[@]}";
do
    for t in "${TYPES[@]}";
    do
        stater="
[stat./sequential/search*{arg_service:$s AND arg_fraud-request-type:$t}]
metrics = httpcodes, requesttimes, requesthist
prefix = $s"_"$t
precise-histogram = false"
        echo -e "$stater" >> staters.conf
    done
done

SERVICES=("so_fraud_login_id")
TYPES=(
    "VERIFICATION_LEVEL")

for s in "${SERVICES[@]}";
do
    for t in "${TYPES[@]}";
    do
        stater="
[stat./sequential/search*{arg_service:$s AND arg_fraud-request-type:$t}]
metrics = httpcodes, requesttimes, requesthist
prefix = $s"_"$t
precise-histogram = false"
        echo -e "$stater" >> staters.conf
    done
done

#TYPES=(
#    "VERIFICATION_LEVEL")
#
#for t in "${TYPES[@]}";
#do
#    stater="
#[stat./sequential/search*{arg_fraud-request-type:$t}]
#metrics = httpcodes, requesttimes, requesthist
#prefix = $s"_"$t
#precise-histogram = false"
#    echo -e "$stater" >> staters.conf
#done

