package ru.yandex.search.translit;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public enum LocaleRuTableSelector implements TranslitTableSelector {
    INSTANCE;

    private static final Set<String> ASCII =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList("translitEnRu", "layoutEnRu")));

    private static final Set<String> NONASCII =
        Collections.unmodifiableSet(
            new LinkedHashSet<>(
                Arrays.asList("translitRuEn", "layoutRuEn")));
    @Override
    public boolean useTable(final String request, final String table) {
        boolean asciiString = request.chars().allMatch(c -> c < 128);
        if (asciiString) {
            return ASCII.contains(table);
        } else {
            return NONASCII.contains(table);
        }
    }
}
