package ru.yandex.search.translit;

public class TranslitContext {
    private final String request;
    private final char[] requestChars;
    private final StringBuilder sb;

    public TranslitContext(final String request) {
        this.request = request;
        requestChars = request.toCharArray();
        sb = new StringBuilder(request.length() << 1);
    }

    public String request() {
        return request;
    }

    public char[] requestChars() {
        return requestChars;
    }

    public StringBuilder sb() {
        return sb;
    }
}
