package ru.yandex.search.translit;

import java.util.Map;

public class TranslitDoubleCharTable extends TranslitSingleCharTable {
        private final Map<Integer, char[]> doubleCharTable;

    public TranslitDoubleCharTable(
        final String name,
        final char[] replacementTable,
        final char[][] multiReplacementTable,
        final Map<Integer, char[]> doubleCharTable)
        {
            super(
                name,
                replacementTable,
                new boolean[0],
                multiReplacementTable);
            this.doubleCharTable = doubleCharTable;
        }

        @Override
        public String translate(final TranslitContext context) {
            StringBuilder sb = context.sb();
            sb.setLength(0);
            char[] request = context.requestChars();
            boolean translated = false;
            for (int i = 0; i < request.length; ++i) {
                char c = request[i];
                int next = i + 1;
                if (next < request.length) {
                    char[] replacement =
                        doubleCharTable.get(Translit.charsToInt(c, request[next]));
                    if (replacement == null) {
                        if (translateChar(c, sb)) {
                            translated = true;
                        }
                    } else {
                        for (char replaced: replacement) {
                            sb.append(replaced);
                        }
                        translated = true;
                        i++;
                    }
                } else {
                    if (translateChar(c, sb)) {
                        translated = true;
                    }
                }
            }
            if (translated) {
                return sb.toString();
            } else {
                return context.request();
            }
        }
}
