package ru.yandex.search.translit;

public class TranslitSingleCharTable implements TranslitTable {
    private final String name;
    private final char[] replacementTable;
    private final char replacementOffset;
    private final char replacementMax;
    private final boolean[] exceptionsTable;
    private final char exceptionsOffset;
    private final char exceptionsMax;
    private final char[][] multiReplacementTable;
    private final char multiReplacementOffset;
    private final char multiReplacementMax;

    TranslitSingleCharTable(
        final String name,
        final char[] replacementTable,
        final boolean[] exceptionsTable,
        final char[][] multiReplacementTable)
    {
        this.name = name;
        int replacementOffset = 0;
        int replacementLength = 0;
        for (int i = 0; i < replacementTable.length; ++i) {
            if (replacementTable[i] != 0) {
                if (replacementOffset == 0) {
                    replacementOffset = i;
                }
                replacementLength = i - replacementOffset + 1;
            }
        }
        this.replacementTable = new char[replacementLength];
        for (int i = 0; i < replacementLength; ++i) {
            this.replacementTable[i] =
                replacementTable[i + replacementOffset];
        }
        this.replacementOffset = (char) replacementOffset;
        replacementMax = (char) (replacementOffset + replacementLength);

        int exceptionsOffset = 0;
        int exceptionsLength = 0;
        for (int i = 0; i < exceptionsTable.length; ++i) {
            if (exceptionsTable[i]) {
                if (exceptionsOffset == 0) {
                    exceptionsOffset = i;
                }
                exceptionsLength = i - exceptionsOffset + 1;
            }
        }
        this.exceptionsTable = new boolean[exceptionsLength];
        for (int i = 0; i < exceptionsLength; ++i) {
            this.exceptionsTable[i] =
                exceptionsTable[i + exceptionsOffset];
        }
        this.exceptionsOffset = (char) exceptionsOffset;
        exceptionsMax = (char) (exceptionsOffset + exceptionsLength);

        int multiReplacementOffset = 0;
        int multiReplacementLength = 0;
        for (int i = 0; i < multiReplacementTable.length; ++i) {
            if (multiReplacementTable[i] != null) {
                if (multiReplacementOffset == 0) {
                    multiReplacementOffset = i;
                }
                multiReplacementLength = i - multiReplacementOffset + 1;
            }
        }
        this.multiReplacementTable = new char[multiReplacementLength][];
        for (int i = 0; i < multiReplacementLength; ++i) {
            this.multiReplacementTable[i] =
                multiReplacementTable[i + multiReplacementOffset];
        }
        this.multiReplacementOffset = (char) multiReplacementOffset;
        multiReplacementMax =
            (char) (multiReplacementOffset + multiReplacementLength);
    }

    protected boolean translateChar(final char c, final StringBuilder sb) {
        if (c >= exceptionsOffset
            && c < exceptionsMax
            && exceptionsTable[c - exceptionsOffset])
        {
            sb.append(c);
            return false;
        }
        char replacement;
        if (c < replacementOffset || c >= replacementMax) {
            replacement = 0;
        } else {
            replacement = replacementTable[c - replacementOffset];
        }
        boolean translated;
        if (replacement == 0) {
            char[] replacements;
            if (c < multiReplacementOffset || c >= multiReplacementMax) {
                replacements = null;
            } else {
                replacements =
                    multiReplacementTable[c - multiReplacementOffset];
            }
            if (replacements == null) {
                sb.append(c);
                translated = false;
            } else {
                for (char replaced: replacements) {
                    sb.append(replaced);
                }
                translated = true;
            }
        } else {
            sb.append(replacement);
            translated = true;
        }
        return translated;
    }

    @Override
    public String translate(final TranslitContext context) {
        StringBuilder sb = context.sb();
        sb.setLength(0);
        boolean translated = false;
        for (char c: context.requestChars()) {
            if (translateChar(c, sb)) {
                translated = true;
            }
        }
        if (translated) {
            return sb.toString();
        } else {
            return context.request();
        }
    }

    @Override
    public String name() {
        return name;
    }
}
