package ru.yandex.search.proxy.universal;

import ru.yandex.client.producer.ProducerClientConfig;
import ru.yandex.client.producer.ProducerClientConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.AbstractSearchProxyConfigBuilder;
import ru.yandex.search.request.config.SearchBackendRequestsConfig;
import ru.yandex.search.request.config.SearchBackendRequestsConfigBuilder;

public abstract class AbstractUniversalSearchProxyConfigBuilder
    <T extends AbstractSearchProxyConfigBuilder<T>>
    extends AbstractSearchProxyConfigBuilder<T>
    implements UniversalSearchProxyConfig
{
    private ProducerClientConfigBuilder producerClientConfig;
    private SearchBackendRequestsConfigBuilder searchBackendRequestsConfig;

    protected AbstractUniversalSearchProxyConfigBuilder(
        final UniversalSearchProxyConfig config)
    {
        super(config);
        producerClientConfig(config.producerClientConfig());
        searchBackendRequestsConfig(config.searchBackendRequestsConfig());
    }

    protected AbstractUniversalSearchProxyConfigBuilder(
        final IniConfig config,
        final UniversalSearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        searchBackendRequestsConfig =
            new SearchBackendRequestsConfigBuilder(
                config,
                defaults.searchBackendRequestsConfig());

        IniConfig producerSection = config.sectionOrNull("producer");
        ProducerClientConfig producerDefaults =
            defaults.producerClientConfig();
        if (producerSection == null) {
            producerClientConfig(producerDefaults);
        } else if (producerDefaults == null) {
            producerClientConfig =
                new ProducerClientConfigBuilder(producerSection);
        } else {
            producerClientConfig = new ProducerClientConfigBuilder(
                producerSection,
                producerDefaults);
        }
    }

    @Override
    public ProducerClientConfigBuilder producerClientConfig() {
        return producerClientConfig;
    }

    public T producerClientConfig(
        final ProducerClientConfig producerClientConfig)
    {
        if (producerClientConfig == null) {
            this.producerClientConfig = null;
        } else {
            this.producerClientConfig =
                new ProducerClientConfigBuilder(producerClientConfig);
        }
        return self();
    }

    @Override
    public SearchBackendRequestsConfigBuilder searchBackendRequestsConfig() {
        return searchBackendRequestsConfig;
    }

    public T searchBackendRequestsConfig(
        final SearchBackendRequestsConfig config) {
        this.searchBackendRequestsConfig = new SearchBackendRequestsConfigBuilder(config);
        return self();
    }
}

