package ru.yandex.search.proxy.universal;

import ru.yandex.client.producer.ImmutableProducerClientConfig;
import ru.yandex.client.producer.ProducerClientConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.ImmutableSearchProxyConfig;
import ru.yandex.search.request.config.ImmutableSearchBackendRequestsConfig;
import ru.yandex.search.request.config.SearchBackendRequestsConfig;

public class ImmutableUniversalSearchProxyConfig
    extends ImmutableSearchProxyConfig
    implements UniversalSearchProxyConfig
{
    private final ImmutableProducerClientConfig producerClientConfig;
    private final ImmutableSearchBackendRequestsConfig searchBackendRequestsConfig;

    public ImmutableUniversalSearchProxyConfig(
        final UniversalSearchProxyConfig config)
        throws ConfigException
    {
        super(config);
        ProducerClientConfig producerClientConfig =
            config.producerClientConfig();

        searchBackendRequestsConfig =
            new ImmutableSearchBackendRequestsConfig(
                config.searchBackendRequestsConfig());

        if (producerClientConfig == null) {
            this.producerClientConfig = null;
        } else {
            this.producerClientConfig =
                new ImmutableProducerClientConfig(producerClientConfig);
        }
    }

    @Override
    public ImmutableProducerClientConfig producerClientConfig() {
        return producerClientConfig;
    }

    @Override
    public SearchBackendRequestsConfig searchBackendRequestsConfig() {
        return searchBackendRequestsConfig;
    }
}

