package ru.yandex.search.proxy.universal;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.HttpEntitySendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.EntityGenerator;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumerFactory;
import ru.yandex.http.util.nio.NByteArrayEntityGeneratorAsyncConsumer;

public class ParallelRequestHandler
    implements HttpAsyncRequestHandler<EntityGenerator>
{
    private final UniversalSearchProxy<?> proxy;

    public ParallelRequestHandler(final UniversalSearchProxy<?> proxy) {
        this.proxy = proxy;
    }

    @Override
    public NByteArrayEntityGeneratorAsyncConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new NByteArrayEntityGeneratorAsyncConsumer();
    }

    @Override
    public void handle(
        final EntityGenerator requestBody,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session = new BasicProxySession(proxy, exchange, context);
        BasicUniversalSearchProxyRequestContext requestContext =
            new BasicUniversalSearchProxyRequestContext(
                proxy,
                session,
                requestBody,
                false);
        proxy.parallelRequest(
            session,
            requestContext,
            requestContext.producerGenerator(),
            NByteArrayEntityAsyncConsumerFactory.OK,
            requestContext.httpClientContextGenerator(),
            new HttpEntitySendingCallback(session));
    }
}

