package ru.yandex.search.proxy.universal;

import java.util.logging.Logger;

import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.parser.searchmap.User;

public class PlainUniversalSearchProxyRequestContext
    implements UniversalSearchProxyRequestContext
{
    private final User user;
    private final Long minPos;
    private final long lagTolerance;
    private final AsyncClient client;
    private final Logger logger;

    public PlainUniversalSearchProxyRequestContext(
        final User user,
        final Long minPos,
        final boolean allowLaggingHosts,
        final AsyncClient client,
        final Logger logger)
    {
        this(
            user,
            minPos,
            allowLaggingHosts ? Long.MAX_VALUE : 0L,
            client,
            logger);
    }

    public PlainUniversalSearchProxyRequestContext(
        final User user,
        final Long minPos,
        final long lagTolerance,
        final AsyncClient client,
        final Logger logger)
    {
        this.user = user;
        this.minPos = minPos;
        this.lagTolerance = lagTolerance;
        this.client = client;
        this.logger = logger;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return minPos;
    }

    @Override
    public long lagTolerance() {
        return lagTolerance;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return client;
    }

    @Override
    public Logger logger() {
        return logger;
    }
}
