package ru.yandex.search.proxy.universal;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class UniversalSearchProxyConfigBuilder
    extends AbstractUniversalSearchProxyConfigBuilder
    <UniversalSearchProxyConfigBuilder>
{
    public UniversalSearchProxyConfigBuilder() {
        super(UniversalSearchProxyConfigDefaults.INSTANCE);
    }

    public UniversalSearchProxyConfigBuilder(
        final UniversalSearchProxyConfig config)
    {
        super(config);
    }

    public UniversalSearchProxyConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, UniversalSearchProxyConfigDefaults.INSTANCE);
    }

    public UniversalSearchProxyConfigBuilder(
        final IniConfig config,
        final UniversalSearchProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public UniversalSearchProxyConfigBuilder self() {
        return this;
    }

    public ImmutableUniversalSearchProxyConfig build() throws ConfigException {
        return new ImmutableUniversalSearchProxyConfig(this);
    }
}

