#!/bin/bash
set -xo pipefail
source recommended_java_args.sh
source classpath.sh

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*70))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.7)}')
fi
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT \
-DBSCONFIG_IHOST=$BSCONFIG_IHOST \
-DBSCONFIG_INAME=$BSCONFIG_INAME \
-DMTN_TAG=$MTN_TAG \
-DREPLICA_NAME=$REPLICA_NAME \
-DINUM=$INUM \
-DTVM_API_HOST=https://tvm-api.yandex.net \
-DTVM_CLIENT_ID=2000031 \
-DBLACKBOX_CLIENT_ID=222 \
-DCORP_BLACKBOX_CLIENT_ID=223 \
-DCONFIG_DIR=$BSCONFIG_IDIR \
-DHOSTNAME=$HOSTNAME \
-Djava.library.path=webtools_api \
"

GC_ARGS="-Xgcpolicy:gencon \
-Xtune:virtualized \
-XcompilationThreads1 \
-Xmx${XMX} \
-Xms${XMS} \
-Xgcthreads$CPU_CORES \
-Xconcurrentbackground1 \
-Xconcurrentlevel100 \
-XXgc:concurrentTrace \
-XXgc:concurrentSweep"

case "$NANNY_SERVICE_ID" in
    mail_search_webtools_dev)
        rm -f webtools.conf.d/disk_*.conf
        rm -f webtools.conf.d/mail_*.conf
        ;;
esac

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $APP_ARGS \
    -cp $CLASSPATH \
    ru.yandex.mail.search.web.WebApi \
    webtools.conf \

