package ru.yandex.mail.search.web;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class ProjectsHandler implements ProxyRequestHandler {
    private final WebApi webApi;

    public ProjectsHandler(final WebApi webApi) {
        this.webApi = webApi;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        JsonType jt =
            JsonTypeExtractor.HUMAN_READABLE.extract(session.params());
        try (JsonWriter writer = jt.create(sbw)) {
            writer.value(webApi.projects());
        }

        session.response(
            HttpStatus.SC_OK,
            new StringEntity(sbw.toString(), StandardCharsets.UTF_8));
    }
}
