package ru.yandex.mail.search.web;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.search.web.info.QueueExtractorFactory;

public class QueueGetHandler implements ProxyRequestHandler {
    private final QueueExtractorFactory factory;

    public QueueGetHandler(final DefaultPsProject webApi) {
        factory = new QueueExtractorFactory(webApi);
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        factory.create(session, new QueueCallback(session));
    }

    private static final class QueueCallback
        extends AbstractProxySessionCallback<
        Map.Entry<String, JsonObject>>
    {
        private QueueCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Map.Entry<String, JsonObject> entry) {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = JsonType.NORMAL.create(sbw)) {
                writer.startObject();
                if (entry != null) {
                    writer.key(entry.getKey());
                    writer.value(entry.getValue());
                }
                writer.endObject();
            } catch (IOException e) {
                failed(e);
                return;
            }

            session.response(HttpStatus.SC_OK, sbw.toString());
        }
    }
}
