package ru.yandex.mail.search.web;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.blackbox.BlackboxSessionUserinfo;
import ru.yandex.blackbox.BlackboxSessionidRequest;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class SessionCheckHandler implements ProxyRequestHandler {
    private final WebApi webApi;

    public SessionCheckHandler(final WebApi webApi) {
        this.webApi = webApi;
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        BlackboxSessionidRequest bbRequest =
            new BlackboxSessionidRequest(
                session.params().getString("sessionid"),
                session.params().getString("host"));

        bbRequest.addHeader(
            YandexHeaders.X_YA_SERVICE_TICKET,
            webApi.corpBlackboxTvm2Ticket());

        Header realIp =
            session.request().getFirstHeader(YandexHeaders.X_REAL_IP);
        if (realIp != null) {
            bbRequest.ip(realIp.getValue());
        }

        webApi.corpBlackboxClient().sessionid(
            bbRequest,
            session.listener().adjustContextGenerator(
                webApi.corpBlackboxClient().httpClientContextGenerator()),
            new SessionCheckCallback(session));
    }

    private static final class SessionCheckCallback
        extends AbstractProxySessionCallback<BlackboxSessionUserinfo>
    {
        private final JsonType jsonType;

        private SessionCheckCallback(
            final ProxySession session)
            throws BadRequestException
        {
            super(session);

            jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        }

        @Override
        public void completed(
            final BlackboxSessionUserinfo blackboxSessionUserinfo)
        {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter writer = jsonType.create(sbw)) {
                writer.startObject();
                writer.key("status");
                writer.value("valid");
                writer.endObject();
            } catch (IOException e) {
                failed(e);
                return;
            }

            session.response(HttpStatus.SC_OK, sbw.toString());
        }
    }
}
