package ru.yandex.mail.search.web;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.mail.search.web.info.QueueExtractorFactory;
import ru.yandex.parser.searchmap.SearchMap;
import ru.yandex.parser.searchmap.SearchMapHost;
import ru.yandex.parser.searchmap.SearchMapRow;
import ru.yandex.parser.searchmap.SearchMapShard;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;

public class UpdateLucenePositionHandler implements ProxyRequestHandler {
    private final WebtoolsProject webApi;

    public UpdateLucenePositionHandler(final WebtoolsProject webApi) {
        this.webApi = webApi;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        String service = session.params().getString("service");
        Long prefix = session.params().getLong("prefix");
        Long queueId = session.params().getLong("queueId");

        Enviroment enviroment =
            session.params().getEnum(
                Enviroment.class,
                "env",
                Enviroment.PROD);

        SearchMap searchMap = webApi.searchmap();
        if (searchMap == null) {
            throw new BadRequestException(
                "No searchmap for enviroment " + enviroment);
        }

        SearchMapRow row = searchMap.row(service);
        if (row == null) {
            throw new BadRequestException("No service found " + service);
        }

        final String uri =
            "/delete?updatePosition&prefix="
            + prefix
            + "&shard=" + prefix
            + "&service=" + service
            + "&position=" + queueId;

        final String content = "{\"prefix\":" + prefix
            + ",\"docs\":[]}";

        final BasicAsyncRequestProducerGenerator post =
            new BasicAsyncRequestProducerGenerator(uri, content);
        post.addHeader(YandexHeaders.ZOO_QUEUE_ID, queueId.toString());
        post.addHeader(
            YandexHeaders.ZOO_SHARD_ID,
            String.valueOf(prefix % QueueExtractorFactory.MAX_SHARDS));
        post.addHeader(YandexHeaders.ZOO_QUEUE, service);

        SearchMapShard shard =
            searchMap.hosts(new User(service, new LongPrefix(prefix)));

        MultiFutureCallback<Object> mfcb =
            new MultiFutureCallback<>(
                new Callback(session, shard));

        for (SearchMapHost host: shard) {
            webApi.searchClient().execute(
                host.indexerHost(),
                post,
                mfcb.newCallback());
        }

        mfcb.done();
    }

    private static final class Callback
        extends AbstractProxySessionCallback<Object>
    {
        private final SearchMapShard shard;

        private Callback(
            final ProxySession session,
            final SearchMapShard shard)
        {
            super(session);

            this.shard = shard;
        }

        @Override
        public void completed(final Object result) {
            StringBuilder sb = new StringBuilder();
            for (SearchMapHost host: shard) {
                sb.append(host.indexerHost());
                sb.append('\n');
            }

            session.response(HttpStatus.SC_OK, sb.toString());
        }
    }
}
