package ru.yandex.mail.search.web.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.mail.search.web.health.base.PsProjectType;
import ru.yandex.mail.search.web.health.update.MetricUpdateTaskFactory;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.searchmap.ImmutableSearchMapConfig;
import ru.yandex.search.mop.manager.config.ImmutableMopManagerConfig;

public class ImmutablePsProjectConfig
     implements PsProjectConfig
{
    private final ImmutableSearchMapConfig searchMapConfig;
    private final ImmutableMopManagerConfig mopConfig;
    private List<MetricUpdateTaskFactory> metrics;
    private final ImmutableHttpTargetConfig searchConfig;
    private final String defaultService;
    private final int metricsUpdateWorkers;
    private final String name;
    private final String description;
    private final String projectId;
    private final PsProjectType projectType;
    private final int luceneShards;
    private final int totalShardsCount;
    private final String luceneDropPassword;
    private final String yasmProject;
    private final String yasmLuceneTemplate;

    public ImmutablePsProjectConfig(
        final PsProjectConfig config)
        throws ConfigException
    {
        this.searchMapConfig =
            new ImmutableSearchMapConfig(
                config.searchMapConfig());
        this.metrics =
            Collections.unmodifiableList(new ArrayList<>(
                config.metrics()));
        this.searchConfig =
            new ImmutableHttpTargetConfig(
                config.searchConfig());
        this.defaultService = config.defaultService();
        this.metricsUpdateWorkers = config.metricsUpdateWorkers();
        this.name = config.name();
        this.description = config.description();
        this.projectId = config.projectId();
        this.projectType = config.projectType();
        this.luceneShards = config.luceneShards();
        this.totalShardsCount = config.totalShardsCount();
        this.luceneDropPassword = config.luceneDropPassword();
        if (luceneShards <= 0 || totalShardsCount <= 0) {
            throw new ConfigException(
                "Invalid lucene shards count " + luceneShards);
        }

        this.yasmProject = config.yasmProject();
        this.yasmLuceneTemplate = config.yasmLuceneTemplate();
        if (config.mopConfig() != null) {
            this.mopConfig = new ImmutableMopManagerConfig(config.mopConfig());
        } else {
            this.mopConfig = null;
        }

    }

    @Override
    public ImmutableSearchMapConfig searchMapConfig() {
        return searchMapConfig;
    }

    @Override
    public List<MetricUpdateTaskFactory> metrics() {
        return metrics;
    }

    @Override
    public ImmutableHttpTargetConfig searchConfig() {
        return searchConfig;
    }

    @Override
    public String defaultService() {
        return defaultService;
    }

    @Override
    public int metricsUpdateWorkers() {
        return metricsUpdateWorkers;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String description() {
        return description;
    }

    @Override
    public String projectId() {
        return projectId;
    }

    @Override
    public PsProjectType projectType() {
        return projectType;
    }

    @Override
    public int luceneShards() {
        return luceneShards;
    }

    @Override
    public String luceneDropPassword() {
        return luceneDropPassword;
    }

    @Override
    public String yasmProject() {
        return yasmProject;
    }

    @Override
    public String yasmLuceneTemplate() {
        return yasmLuceneTemplate;
    }

    @Override
    public int totalShardsCount() {
        return totalShardsCount;
    }

    @Override
    public ImmutableMopManagerConfig mopConfig() {
        return mopConfig;
    }
}
