package ru.yandex.mail.search.web.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableWebApiConfig
     extends ImmutableUniversalSearchProxyConfig
     implements WebApiConfig
{
    private final ImmutableHttpHostConfig diskSearch;
    private final ImmutableURIConfig mds;
    private final ImmutableHttpHostConfig staff;
    private final String staffToken;
    private final Map<String, ImmutablePsProjectConfig> projects;
    private final ImmutableTvm2ClientConfig blackboxTvm2;
    private final ImmutableHttpHostConfig blackbox;
    private final ImmutableHttpHostConfig corpBlackboxConfig;
    private final ImmutableTvm2ClientConfig corpBlackboxTvm2;

    public ImmutableWebApiConfig(
        final WebApiConfig config)
        throws ConfigException
    {
        super(config);
        this.diskSearch = new ImmutableHttpHostConfig(
            config.diskSearch());
        this.mds = new ImmutableURIConfig(
            config.mds());
        this.staff = new ImmutableHttpHostConfig(
            config.staff());
        this.staffToken = config.staffToken();
        Map<String, ImmutablePsProjectConfig> projects =
            new LinkedHashMap<>();
        for (Map.Entry<String, ? extends PsProjectConfig> entry
            : config.projects().entrySet())
        {
            try {
                projects.put(
                    entry.getKey(),
                    entry.getValue().projectType().configBuilder(
                        entry.getValue()).build());
            } catch (ConfigException ce) {
                throw new ConfigException("Failed to build config for " + entry.getKey(), ce);
            }
        }
        this.projects = Collections.unmodifiableMap(projects);
        this.blackboxTvm2 =
            new ImmutableTvm2ClientConfig(
                config.blackboxTvm2());
        this.blackbox = new ImmutableHttpHostConfig(
            config.blackbox());
        this.corpBlackboxConfig =
            new ImmutableHttpHostConfig(
                config.corpBlackboxConfig());
        this.corpBlackboxTvm2 =
            new ImmutableTvm2ClientConfig(
                config.corpBlackboxTvm2());
    }

    @Override
    public ImmutableHttpHostConfig diskSearch() {
        return diskSearch;
    }

    @Override
    public ImmutableURIConfig mds() {
        return mds;
    }

    @Override
    public ImmutableHttpHostConfig staff() {
        return staff;
    }

    @Override
    public String staffToken() {
        return staffToken;
    }

    @Override
    public Map<String, ? extends ImmutablePsProjectConfig> projects() {
        return projects;
    }

    @Override
    public ImmutableTvm2ClientConfig blackboxTvm2() {
        return blackboxTvm2;
    }

    @Override
    public ImmutableHttpHostConfig blackbox() {
        return blackbox;
    }

    @Override
    public ImmutableHttpHostConfig corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    @Override
    public ImmutableTvm2ClientConfig corpBlackboxTvm2() {
        return corpBlackboxTvm2;
    }
}
