package ru.yandex.mail.search.web.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class PsProjectConfigBuilder
     extends AbstractPsProjectConfigBuilder<PsProjectConfigBuilder>
{
    public PsProjectConfigBuilder() {
        this(PsProjectConfigDefaults.INSTANCE);
    }

    public PsProjectConfigBuilder(final PsProjectConfig config) {
        super(config);
    }

    public PsProjectConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, PsProjectConfigDefaults.INSTANCE);
    }

    public PsProjectConfigBuilder(
        final IniConfig config,
        final PsProjectConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutablePsProjectConfig build() throws ConfigException {
        return new ImmutablePsProjectConfig(
            this);
    }

    @Override
    public PsProjectConfigBuilder self() {
        return this;
    }
}
