package ru.yandex.mail.search.web.config;

import java.util.Collections;
import java.util.List;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigDefaults;
import ru.yandex.mail.search.web.health.base.PsProjectType;
import ru.yandex.mail.search.web.health.update.MetricUpdateTaskFactory;
import ru.yandex.parser.searchmap.SearchMapConfig;
import ru.yandex.parser.searchmap.SearchMapConfigDefaults;
import ru.yandex.search.mop.manager.config.MopManagerConfig;
import ru.yandex.search.mop.manager.config.MopManagerConfigDefaults;

public class PsProjectConfigDefaults
     implements PsProjectConfig
{
    public static final PsProjectConfigDefaults INSTANCE =
        new PsProjectConfigDefaults();
    private static final int DEFAULT_SHARDS_COUNT = 65534;

    protected PsProjectConfigDefaults() {
    }

    @Override
    public SearchMapConfig searchMapConfig() {
        return SearchMapConfigDefaults.INSTANCE;
    }

    @Override
    public List<MetricUpdateTaskFactory> metrics() {
        return Collections.emptyList();
    }

    @Override
    public HttpTargetConfig searchConfig() {
        return HttpTargetConfigDefaults.INSTANCE;
    }

    @Override
    public String defaultService() {
        return null;
    }

    @Override
    public int metricsUpdateWorkers() {
        return 2;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public String projectId() {
        return null;
    }

    @Override
    public PsProjectType projectType() {
        return null;
    }

    @Override
    public int luceneShards() {
        return -1;
    }

    @Override
    public String luceneDropPassword() {
        return "";
    }

    @Override
    public String yasmProject() {
        return "none";
    }

    @Override
    public String yasmLuceneTemplate() {
        return "ps_search_backend";
    }

    @Override
    public int totalShardsCount() {
        return DEFAULT_SHARDS_COUNT;
    }

    @Override
    public MopManagerConfig mopConfig() {
        return MopManagerConfigDefaults.INSTANCE;
    }
}
