package ru.yandex.mail.search.web.config;

import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.mail.search.web.Enviroment;
import ru.yandex.mail.search.web.health.base.PsProjectType;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public class WebApiConfigBuilder
     extends AbstractUniversalSearchProxyConfigBuilder<WebApiConfigBuilder>
     implements WebApiConfig
{
    private static final EnumParser<Enviroment> ENV_PARSER =
        new EnumParser<>(
            Enviroment.class);
    protected HttpHostConfigBuilder diskSearch;
    protected HttpHostConfigBuilder staff;
    protected String staffToken;
    protected URIConfigBuilder mds;
    private Tvm2ClientConfigBuilder blackboxTvm2;
    private HttpHostConfigBuilder blackbox;
    private HttpHostConfigBuilder corpBlackboxConfig;
    private Tvm2ClientConfigBuilder corpBlackboxTvm2;
    protected Map<String, AbstractPsProjectConfigBuilder<? extends
        PsProjectConfig>>
        projects;

    public WebApiConfigBuilder(final WebApiConfig config) {
        super(config);
        this.diskSearch(config.diskSearch());
        this.mds(config.mds());
        this.staff(config.staff());
        this.staffToken(config.staffToken());

        this.corpBlackboxConfig(config.corpBlackboxConfig());
        this.corpBlackboxTvm2(config.corpBlackboxTvm2());
        this.blackbox(config.blackbox());
        this.blackboxTvm2(config.blackboxTvm2());
        this.projects(config.projects());
    }

    public WebApiConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, WebApiConfigDefaults.INSTANCE);
    }

    public WebApiConfigBuilder(
        final IniConfig config,
        final WebApiConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.diskSearch =
            new HttpHostConfigBuilder(
                config.section("disk"),
                defaults.diskSearch());
        this.mds = new URIConfigBuilder(
            config.section("mds"),
            defaults.mds());
        IniConfig section = config.sectionOrNull("staff");
        if (section != null) {
            this.staffToken = "OAuth "
                + section.getString("token", defaults.staffToken());
            this.staff = new HttpHostConfigBuilder(section, defaults.staff());
        } else {
            this.staffToken = defaults.staffToken();
            this.staff = new HttpHostConfigBuilder(defaults.staff());
        }

        this.blackbox =
            new HttpHostConfigBuilder(
                config.section("blackbox"),
                defaults.blackbox());
        this.blackboxTvm2 =
            new Tvm2ClientConfigBuilder(
                config.section("blackbox.tvm2"),
                defaults.blackboxTvm2());

        IniConfig corpBlackboxSection = config.section("corp-blackbox");
        corpBlackboxConfig = new HttpHostConfigBuilder(
            corpBlackboxSection,
            defaults.corpBlackboxConfig());
        corpBlackboxTvm2 = new Tvm2ClientConfigBuilder(
            corpBlackboxSection.section("tvm2"),
            defaults.corpBlackboxTvm2());

        projects = new LinkedHashMap<>();
        for (Map.Entry<String, IniConfig> sec : config.sections().entrySet()) {
            if (sec.getKey().startsWith("service_")) {
                PsProjectType psProject =
                    sec.getValue().getEnum(PsProjectType.class, "type");
                AbstractPsProjectConfigBuilder<? extends PsProjectConfig> psc =
                    psProject.configBuilder(sec.getValue());

                projects.put(psc.projectId(), psc);
            }
        }
    }

    public HttpHostConfigBuilder diskSearch() {
        return diskSearch;
    }

    public WebApiConfigBuilder diskSearch(final HttpHostConfig diskSearch) {
        this.diskSearch = new HttpHostConfigBuilder(
            diskSearch);
        return self();
    }

    public HttpHostConfigBuilder staff() {
        return staff;
    }

    public WebApiConfigBuilder staff(final HttpHostConfig config) {
        this.staff = new HttpHostConfigBuilder(
            config);
        return self();
    }

    public URIConfigBuilder mds() {
        return mds;
    }

    public WebApiConfigBuilder mds(final URIConfig mds) {
        this.mds = new URIConfigBuilder(
            mds);
        return self();
    }

    @Override
    public WebApiConfigBuilder self() {
        return this;
    }

    public ImmutableWebApiConfig build() throws ConfigException {
        return new ImmutableWebApiConfig(
            this);
    }

    @Override
    public String staffToken() {
        return staffToken;
    }

    public WebApiConfigBuilder staffToken(final String staffToken) {
        this.staffToken = staffToken;
        return self();
    }

    @Override
    public Map<String, AbstractPsProjectConfigBuilder<? extends PsProjectConfig>> projects() {
        return projects;
    }

    public WebApiConfigBuilder projects(
        final Map<String, ? extends PsProjectConfig> value)
    {
        Map<String, AbstractPsProjectConfigBuilder<? extends
            PsProjectConfig>>
            projects = new LinkedHashMap<>();
        for (Map.Entry<String, ? extends PsProjectConfig> entry
            : value.entrySet())
        {
            projects.put(
                entry.getKey(),
                entry.getValue().projectType().configBuilder(entry.getValue()));
        }

        this.projects = new LinkedHashMap<>(projects);
        return this;
    }

    @Override()
    public Tvm2ClientConfigBuilder blackboxTvm2() {
        return blackboxTvm2;
    }

    public WebApiConfigBuilder blackboxTvm2(final Tvm2ClientConfig value) {
        this.blackboxTvm2 = new Tvm2ClientConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder blackbox() {
        return blackbox;
    }

    public WebApiConfigBuilder blackbox(final HttpHostConfig value) {
        this.blackbox = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder corpBlackboxConfig() {
        return corpBlackboxConfig;
    }

    public WebApiConfigBuilder corpBlackboxConfig(final HttpHostConfig value) {
        this.corpBlackboxConfig = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override()
    public Tvm2ClientConfigBuilder corpBlackboxTvm2() {
        return corpBlackboxTvm2;
    }

    public WebApiConfigBuilder corpBlackboxTvm2(final Tvm2ClientConfig value) {
        this.corpBlackboxTvm2 = new Tvm2ClientConfigBuilder(
            value);
        return self();
    }
}
