package ru.yandex.mail.search.web.config;

import java.util.Collections;
import java.util.Map;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class WebApiConfigDefaults
     extends UniversalSearchProxyConfigDefaults
     implements WebApiConfig
{
    public static final WebApiConfigDefaults INSTANCE =
        new WebApiConfigDefaults();

    @Override
    public HttpHostConfig diskSearch() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig mds() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig blackboxTvm2() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig blackbox() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig staff() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public String staffToken() {
        return null;
    }

    @Override
    public HttpHostConfig corpBlackboxConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ClientConfig corpBlackboxTvm2() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }

    protected WebApiConfigDefaults() {
    }

    @Override
    public Map<String, ? extends PsProjectConfig> projects() {
        return Collections.emptyMap();
    }
}
